unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.Edit, FMX.Controls.Presentation, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Error, FireDAC.UI.Intf, FireDAC.Phys.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool, FireDAC.Stan.Async, FireDAC.Phys, FireDAC.Phys.PG,
  FireDAC.Phys.PGDef, FireDAC.FMXUI.Wait, Data.DB, FireDAC.Comp.Client,
  FMX.Memo.Types, FMX.ScrollBox, FMX.Memo;

type
  TForm1 = class(TForm)
    EditIP: TEdit;
    BtnProbar: TButton;
    Label1: TLabel;
    Label2: TLabel;
    FDConnection1: TFDConnection;
    FDPhysPgDriverLink1: TFDPhysPgDriverLink;
    MemoResultado: TMemo;
    EditUsuario: TEdit;
    EditPassword: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    EditBaseDatos: TEdit;
    Label5: TLabel;
    procedure BtnProbarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

procedure TForm1.FormCreate(Sender: TObject);
begin
  EditIP.Text := '127.0.0.1';
  EditUsuario.Text := 'postgres';
  EditBaseDatos.Text := 'postgres';
  MemoResultado.Lines.Clear;
end;

procedure TForm1.BtnProbarClick(Sender: TObject);
var
  IP, Usuario, Password, BaseDatos: string;
begin
  MemoResultado.Lines.Clear;
  
  IP := Trim(EditIP.Text);
  Usuario := Trim(EditUsuario.Text);
  Password := EditPassword.Text;
  BaseDatos := Trim(EditBaseDatos.Text);
  
  if IP = '' then
  begin
    MemoResultado.Lines.Add('ERROR: Debe ingresar una dirección IP');
    Exit;
  end;
  
  if Usuario = '' then
  begin
    MemoResultado.Lines.Add('ERROR: Debe ingresar un usuario');
    Exit;
  end;
  
  if BaseDatos = '' then
  begin
    MemoResultado.Lines.Add('ERROR: Debe ingresar el nombre de la base de datos');
    Exit;
  end;
  
  FDConnection1.Connected := False;
  FDConnection1.Params.Clear;
  FDConnection1.Params.Add('DriverID=PG');
  FDConnection1.Params.Add('Server=' + IP);
  FDConnection1.Params.Add('Port=5432');
  FDConnection1.Params.Add('Database=' + BaseDatos);
  FDConnection1.Params.Add('User_Name=' + Usuario);
  FDConnection1.Params.Add('Password=' + Password);
  FDConnection1.LoginPrompt := False;
  
  MemoResultado.Lines.Add('Intentando conectar a:');
  MemoResultado.Lines.Add('  IP: ' + IP);
  MemoResultado.Lines.Add('  Puerto: 5432');
  MemoResultado.Lines.Add('  Usuario: ' + Usuario);
  MemoResultado.Lines.Add('  Base de Datos: ' + BaseDatos);
  MemoResultado.Lines.Add('');
  MemoResultado.Lines.Add('Probando conexión...');
  
  BtnProbar.Enabled := False;
  try
    try
      FDConnection1.Connected := True;
      MemoResultado.Lines.Add('');
      MemoResultado.Lines.Add('✓ CONEXIÓN EXITOSA');
      MemoResultado.Lines.Add('El enlace con PostgreSQL fue establecido correctamente.');
      FDConnection1.Connected := False;
    except
      on E: Exception do
      begin
        MemoResultado.Lines.Add('');
        MemoResultado.Lines.Add('✗ ERROR DE CONEXIÓN');
        MemoResultado.Lines.Add('No se pudo establecer conexión con el servidor.');
        MemoResultado.Lines.Add('');
        MemoResultado.Lines.Add('Detalles del error:');
        MemoResultado.Lines.Add(E.Message);
      end;
    end;
  finally
    BtnProbar.Enabled := True;
  end;
end;

end.